--[[
Copyright (C) GtX (Andy), 2021

Author: GtX | Andy
Date: 14.04.2021
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]


TransferOwnershipEvent = {}

TransferOwnershipEvent.SEND_NUM_BITS = 8

local TransferOwnershipEvent_mt = Class(TransferOwnershipEvent, Event)
InitEventClass(TransferOwnershipEvent, "TransferOwnershipEvent")

function TransferOwnershipEvent.emptyNew()
    return Event.new(TransferOwnershipEvent_mt)
end

function TransferOwnershipEvent.new(objects, destinationFarmId, owningPlaceable)
    local self = TransferOwnershipEvent.emptyNew()

    self.objects = objects
    self.destinationFarmId = destinationFarmId
    self.owningPlaceable = owningPlaceable

    return self
end

function TransferOwnershipEvent.newServerToClient(owningPlaceable)
    local self = TransferOwnershipEvent.emptyNew()

    self.owningPlaceable = owningPlaceable

    return self
end

function TransferOwnershipEvent:readStream(streamId, connection)
    if not connection:getIsServer() then
        local numObjects = streamReadUIntN(streamId, TransferOwnershipEvent.SEND_NUM_BITS)

        self.objects = {}

        if numObjects > 0 then
            for i = 1, numObjects do
                local object = NetworkUtil.readNodeObject(streamId)

                if object ~= nil then
                    table.insert(self.objects, object)
                end
            end
        end

        self.destinationFarmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
        self.owningPlaceable = NetworkUtil.readNodeObject(streamId)
    else
        self.owningPlaceable = NetworkUtil.readNodeObject(streamId)
    end

    self:run(connection)
end

function TransferOwnershipEvent:writeStream(streamId, connection)
    if connection:getIsServer() then
        local numObjects = self.objects ~= nil and math.min(#self.objects, 2 ^ TransferOwnershipEvent.SEND_NUM_BITS - 1) or 0

        streamWriteUIntN(streamId, numObjects, TransferOwnershipEvent.SEND_NUM_BITS)

        if numObjects > 0 then
            for i = 1, numObjects do
                NetworkUtil.writeNodeObject(streamId, self.objects[i])
            end
        end

        streamWriteUIntN(streamId, self.destinationFarmId, FarmManager.FARM_ID_SEND_NUM_BITS)
        NetworkUtil.writeNodeObject(streamId, self.owningPlaceable)
    else
        NetworkUtil.writeNodeObject(streamId, self.owningPlaceable)
    end
end

function TransferOwnershipEvent:run(connection)
    if not connection:getIsServer() then
        local senderFarmId = g_currentMission:getFarmId(connection) or FarmManager.SPECTATOR_FARM_ID

        if g_currentMission:getHasPlayerPermission("transferMoney", connection, senderFarmId) then
            TransferOwnershipEvent.setObjectsOwnerFarmId(self.objects, senderFarmId, self.destinationFarmId, self.owningPlaceable)
        end
    else
        local transferPoint = nil

        if self.owningPlaceable ~= nil and self.owningPlaceable.getTransferOwnershipPoint ~= nil then
            transferPoint = self.owningPlaceable:getTransferOwnershipPoint()

            if TransferOwnershipManager.DEBUG_ENABLED then
                printf("  DevInfo: [TransferOwnershipEvent] Updating objects for transfer point placeable with name %s!", self.owningPlaceable:getName() or "Unknown" )
            end
        end

        g_messageCenter:publish(MessageType.TRANSFER_OWNERSHIP_UPDATE_OBJECTS, transferPoint)
    end
end

function TransferOwnershipEvent.setObjectsOwnerFarmId(objects, senderFarmId, destinationFarmId, owningPlaceable)
    local numObjects = 0

    if objects ~= nil and destinationFarmId ~= nil and destinationFarmId <= FarmManager.MAX_FARM_ID and g_farmManager:getFarmById(destinationFarmId) ~= nil then
        for _, object in ipairs (objects) do
            if object.findRootVehicle ~= nil then
                local rootVehicle = object:findRootVehicle() or object

                if rootVehicle.getAttachedImplements ~= nil then
                    local implements = rootVehicle:getAttachedImplements()
                    local numImplements = implements ~= nil and #implements or 0

                    if numImplements > 0 then
                        for i = numImplements, 1, -1 do
                            rootVehicle:detachImplement(1)
                        end
                    end
                end
            end

            object:setOwnerFarmId(destinationFarmId)

            numObjects += 1
        end
    end

    if TransferOwnershipManager.DEBUG_ENABLED then
        if numObjects > 0 then
            local senderFarm = g_farmManager:getFarmById(senderFarmId)
            local destinationFarm = g_farmManager:getFarmById(destinationFarmId)

            local senderFarmName = senderFarm and senderFarm.name or "Unknown"
            local destinationFarmName = destinationFarm and destinationFarm.name or "Unknown"

            printf("  DevInfo: [TransferOwnershipEvent] Transferred %d objects from %s (%s) to %s (%s).", numObjects, senderFarmName, senderFarmId, destinationFarmName, destinationFarmId)
        else
            print("  DevError: [TransferOwnershipEvent] Object transfer failed!")
        end
    end

    g_server:broadcastEvent(TransferOwnershipEvent.newServerToClient(owningPlaceable))

    return numObjects > 0
end
