--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

productionStorageControl.wrapped = {}
productionStorageControl.wrapped["SILAGE"] = true
--productionStorageControl.wrapped["COTTON"] = true
productionStorageControl.wrapped["SUGARBEET_CUT"] = true
productionStorageControl.wrapped["FORAGE"] = true
productionStorageControl.wrapped["GRASS_FERMENTED"] = true
productionStorageControl.wrapped["CHOPPEDMAIZE_FERMENTED"] = true
productionStorageControl.emptyIcon = g_currentModDirectory.."gui/emptyFillType.dds"



--Spawn-Optionenen anzeigen wenn vorhanden und zusätzlich Option um Menü zu öffnen
function productionStorageControl:run(superFunc, menue)
	local ownerFarmId = self.productionPoint:getOwnerFarmId()
	if ownerFarmId == AccessHandler.EVERYONE and self.productionPoint.useInteractionTriggerForBuying then
		self.productionPoint:buyRequest()
	elseif ownerFarmId == self.mission:getFarmId() then
		--Produktionsmenü öffnen wenn kein Palletspawner vorhanden ist
		if self.productionPoint.palletSpawner == nil then
			self.productionPoint:openMenu()
		else
			local options = {}
			--Ballen laden
			if self.baleTypes == nil then
				self.baleTypes = productionStorageControl:getBaleTypes()
			end

			--Auslesen was ein FillLevel hat und Palette/Ballen
			local outputFillTypes = {}
			for _, fillTypeIndex in ipairs(self.productionPoint.outputFillTypeIdsArray) do
				local fillLevel = self.productionPoint:getFillLevel(fillTypeIndex)
				local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)

				if fillLevel > 1 and (fillType.palletFilename ~= nil or self.baleTypes[fillTypeIndex] ~= nil or fillType.name == "TREESAPLINGS") then
					local entry = {}
					entry.title = fillType.title
					entry.fillLevel = fillLevel
					entry.fillTypeIndex = fillTypeIndex
					table.insert(outputFillTypes, entry)

					--Baumsetzlinge 2x eintragen damit beide Paletten vorhanden sind
					if fillType.name == "TREESAPLINGS" then
						self.treeTypes = productionStorageControl:getTreeTypes()
						table.insert(outputFillTypes, entry)
					end
				end
			end

			--SortierFunktion
			local function compAvailableItems(w1,w2)
				return w1.title < w2.title
			end

			--Sortieren Alphabetisch
			table.sort(outputFillTypes, compAvailableItems)

			--Option Produktionsmenü öffnen, fillTypeIndex = 0 -> Menü, Eintrag Lager leer falls nötig
			if menue ~= true then
				local option = {}
				option.openmenu = true
				option.title = g_i18n:getText("ProductionStorageControl_OpenProduction")
				option.fillTypeIndex = 0
				option.fillLevel = 0
				option.packages = {}
				option.fillTypeIcon = productionStorageControl.emptyIcon
				local pallet = {}
				pallet.max = 0
				pallet.title = ""
				pallet.capacity = 0
				pallet.modIcon = productionStorageControl.emptyIcon
				if #outputFillTypes == 1 then
					pallet.title = " "
				end
				table.insert(option.packages, pallet)
				table.insert(options, option)
			end

			local treePallet = false
			for i=1, #outputFillTypes do
				local fillTypeIndex = outputFillTypes[i].fillTypeIndex
				local currentFillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)

				local option = {}
				option.fillTypeIndex = fillTypeIndex
				option.fillLevel = outputFillTypes[i].fillLevel
				option.fillTypeIcon = currentFillType.hudOverlayFilename

				--Sollte keine UnitShort gegeben sein, Liter anzeigen
				if currentFillType.unitShort == "" then
					currentFillType.unitShort = g_i18n:getText("unit_literShort")
				end
				option.unitShort = currentFillType.unitShort
				option.title = currentFillType.title .. " ("..g_i18n:formatVolume(outputFillTypes[i].fillLevel, 0, currentFillType.unitShort)..")"
				option.packages = {}

				--Sonderfall Baumsetzlinge
				if currentFillType.name == "TREESAPLINGS" then
					local palletXML = Utils.getFilename("$data/objects/pallets/treeSaplingPallet01/treeSaplingPallet01.xml", self.baseDirectory)
					local type = 4
					if treePallet == true then
						palletXML = Utils.getFilename("$data/objects/pallets/treeSaplingPallet02/treeSaplingPallet02.xml", self.baseDirectory)
						type = 5
					end
					treePallet = true
					local palletXmlFile = XMLFile.load("palletXmlFilename", palletXML, Vehicle.xmlSchema)
					local capacity = FillUnit.getCapacityFromXml(palletXmlFile)
					palletXmlFile:delete()
					local size = StoreItemUtil.getSizeValues(palletXML, "vehicle", 0, {})
					local max = math.floor(outputFillTypes[i].fillLevel / capacity)
					if ((outputFillTypes[i].fillLevel - (max*capacity)) >= 1) then
						max = max + 1
					end

					for i, treeType in pairs(self.treeTypes) do
						local tree = {}
						tree.capacity = capacity
						tree.max = max
						tree.width = size.width
						tree.height = size.height
						tree.length = size.length
						tree.type = type
						tree.customEnvironment = nil

						tree.treeId = treeType.treeId
						tree.title = g_i18n:getText("typeDesc_pallet") .. " "..treeType.name.." ("..tree.capacity.." "..currentFillType.unitShort..")"
						table.insert(option.packages, tree)
						tree = nil
					end
				end

				--Palette eintragen wenn vorhanden
				if currentFillType.palletFilename ~= nil and currentFillType.name ~= "TREESAPLINGS" then

					--Palette Eintragen aus Palletspawner wenn abweichend
					if self.productionPoint.palletSpawner.fillTypeIdToPallet ~= nil and self.productionPoint.palletSpawner.fillTypeIdToPallet[fillTypeIndex] ~= nil then
						local pallet = self.productionPoint.palletSpawner.fillTypeIdToPallet[fillTypeIndex]
						if pallet.filename ~= currentFillType.palletFilename then
							local thisPallet = XMLFile.load("palletXmlFilename", pallet.filename, Vehicle.xmlSchema)

							if thisPallet ~= nil then
								local size = StoreItemUtil.getSizeValues(pallet.filename, "vehicle", 0, {})
								local capacity = FillUnit.getCapacityFromXml(thisPallet)
								thisPallet:delete()

								local pallet = {}
								pallet.capacity = capacity

								pallet.max = math.floor(outputFillTypes[i].fillLevel / pallet.capacity)
								if ((outputFillTypes[i].fillLevel - (pallet.max*pallet.capacity)) >= 1) then
									pallet.max = pallet.max + 1
								end

								pallet.title = g_i18n:getText("typeDesc_pallet") .. " ("..pallet.capacity.." "..currentFillType.unitShort..")"
								pallet.modIcon = g_modManager:getModByName(self.productionPoint.owningPlaceable.customEnvironment).iconFilename

								pallet.width = size.width
								pallet.height = size.height
								pallet.length = size.length
								pallet.type = 6 -- = Palette Produktion
								pallet.customEnvironment = enviroment
								table.insert(option.packages, pallet)
							end
						end
					end

					for enviroment, currentPallet in pairs(currentFillType.pallets) do
					--XML laden für CAPACITY
						local thisPallet = XMLFile.load("palletXmlFilename", currentPallet, Vehicle.xmlSchema)

						if thisPallet ~= nil then
							local size = StoreItemUtil.getSizeValues(currentPallet, "vehicle", 0, {})
							local capacity = FillUnit.getCapacityFromXml(thisPallet)
							thisPallet:delete()

							local pallet = {}
							pallet.capacity = capacity

							pallet.max = math.floor(outputFillTypes[i].fillLevel / pallet.capacity)
							if ((outputFillTypes[i].fillLevel - (pallet.max*pallet.capacity)) >= 1) then
								pallet.max = pallet.max + 1
							end

							pallet.title = g_i18n:getText("typeDesc_pallet") .. " ("..pallet.capacity.." "..currentFillType.unitShort..")"
							pallet.modIcon = productionStorageControl.emptyIcon
							if enviroment ~= "VANILLA" then
								pallet.modIcon = g_modManager:getModByName(enviroment).iconFilename
							end

							pallet.width = size.width
							pallet.height = size.height
							pallet.length = size.length
							pallet.type = 1 -- = Palette
							pallet.customEnvironment = enviroment
							table.insert(option.packages, pallet)
						end
					end
				end

				--Ballen eintragen wenn vorhanden
				if self.baleTypes[fillTypeIndex] ~= nil then
					local baleType = self.baleTypes[fillTypeIndex]
					for index, baleSize in ipairs(baleType.sizes) do
						local bale = {}
						bale.capacity = baleSize.capacity
						bale.width = baleSize.width
						bale.height = baleSize.height
						bale.length = baleSize.length
						bale.type = 2 -- = squarebale
						bale.customEnvironment = baleSize.customEnvironment
						bale.modIcon = productionStorageControl.emptyIcon
						if bale.customEnvironment ~= "VANILLA" then
							bale.modIcon = g_modManager:getModByName(bale.customEnvironment).iconFilename
						end
						if baleSize.isRoundbale == true then
							bale.type = 3 -- = roundbale
							--Höhe, Breite und Tiefe tauschen, da der Ballen auf der Seite gespawnt wird
							bale.length = baleSize.diameter
							bale.height = baleSize.diameter
						end

						if productionStorageControl.wrapped[currentFillType.name] ~= nil then
							bale.wrapped = true
						end

						if currentFillType.name == "COTTON" and baleSize.isRoundbale == false then
						--Drehen damit der Ballen besser passt
							bale.length = baleSize.height
							bale.height = baleSize.width
							bale.width = baleSize.length
							bale.wrapped = false
						end

						bale.max = math.floor(outputFillTypes[i].fillLevel / bale.capacity)
						if ((outputFillTypes[i].fillLevel - (bale.max*bale.capacity)) >= 1) then
							bale.max = bale.max + 1
						end

						bale.title = g_i18n:getText("fillType_squareBale") .. " " .. tostring(baleSize.length) .. "m ("..g_i18n:formatVolume(bale.capacity, 0, currentFillType.unitShort)..")"
						if baleSize.isRoundbale then
							bale.title = g_i18n:getText("fillType_roundBale") .. " " .. tostring(baleSize.diameter) .. "m ("..g_i18n:formatVolume(bale.capacity, 0, currentFillType.unitShort)..")"
						end
						table.insert(option.packages, bale)
					end
				end
				table.insert(options, option)
			end

			--keine Optionen verhindern
			if #options == 0 then
				local option = {}
				option.openmenu = true
				option.title = g_i18n:getText("ProductionStorageControl_StorageEmpty")
				option.fillTypeIndex = 0
				option.fillLevel = 0
				option.packages = {}
				option.fillTypeIcon = productionStorageControl.emptyIcon
				local pallet = {}
				pallet.max = 0
				pallet.capacity = 0
				pallet.title = g_i18n:getText("ProductionStorageControl_StorageEmpty")
				pallet.modIcon = productionStorageControl.emptyIcon
				table.insert(option.packages, pallet)
				table.insert(options, option)
			end

			local farms = g_farmManager:getFarms()
			local farmList = {}

			for _, farm in pairs(farms) do
				if not farm.isSpectator and (farm ~= self.playerFarm and farm.showInFarmScreen) then
					table.insert(farmList, farm)
				end
			end
			--Dialog aufrufen
			ProductionStorageDialog.show(farmList, nil, self.productionPoint:getName(), options, self.productionPoint)
		end
	end
end

ProductionPointActivatable.run = Utils.overwrittenFunction(ProductionPointActivatable.run, productionStorageControl.run)


--Gewählte Verpackung spawnen
function ProductionPoint:ReceiveSpawnEvent(ownerFarmId, fillTypeIndex, pendingLiters, width, height, length, capacity, type, customEnvironment, treeId, amount, color1, color2, color3)
	local item = {}
	item.size = {}
	item.size.height = height
	item.size.width = width
	item.size.length = length
	item.capacity = capacity
	item.type = type
	item.treeId = treeId
	item.customEnvironment = customEnvironment
	item.ownerFarmId = ownerFarmId
	--Richtigen XML-Pfad bestimmen
	if item.type == 1 then
		currentFillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
		item.filename = currentFillType.pallets[customEnvironment]
	elseif item.type == 4 then
		item.filename = Utils.getFilename("$data/objects/pallets/treeSaplingPallet01/treeSaplingPallet01.xml", self.baseDirectory)
	elseif item.type == 5 then
		item.filename = Utils.getFilename("$data/objects/pallets/treeSaplingPallet02/treeSaplingPallet02.xml", self.baseDirectory)
	elseif item.type == 6 then
		item.filename = self.palletSpawner.fillTypeIdToPallet[fillTypeIndex].filename
	else
		local isRoundbale = false
		local diameter = 0
		if item.type == 3 then
			isRoundbale = true
			diameter = length
		end
		local currentFillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
		if currentFillType.name == "COTTON" and isRoundbale == false then
			height = item.size.length
			width = item.size.height
			length = item.size.width
		end
		item.filename = g_baleManager:getBaleXMLFilename(fillTypeIndex, isRoundbale, width, height, length, diameter, customEnvironment)
		item.color1 = color1
		item.color2 = color2
		item.color3 = color3
	end
	--Hinterlegen für später
	self.palletSpawner.pendingLiters[fillTypeIndex] = pendingLiters
	self.palletSpawner.pendingItem[fillTypeIndex] = item

	for i = 1, amount do
	table.insert(self.palletSpawner.spawnQueue, {
		pallet = self.palletSpawner.pendingItem[fillTypeIndex],
		fillType = fillTypeIndex,
		farmId = self.palletSpawner.pendingItem[fillTypeIndex].ownerFarmId,
		callback = self.getPalletCallback,
		callbackTarget = self
	})
	end
	g_currentMission:addUpdateable(self.palletSpawner)
end


function ProductionPoint:getPalletCallback(pallet, result, fillTypeIndex)
--Production Revamp: Spawner abschalten, da Palette gespawnt wurde
	self.spawnPending = false
	if pallet ~= nil then
		pallet.fillTypeIndex = fillTypeIndex

		local delta = 0
		--Nur ausführen sollte es eine Palette sein
		if self.palletSpawner.pendingItem[fillTypeIndex].type == 1 or self.palletSpawner.pendingItem[fillTypeIndex].type == 4 or self.palletSpawner.pendingItem[fillTypeIndex].type == 5 or self.palletSpawner.pendingItem[fillTypeIndex].type == 6 then
			if result == PalletSpawner.RESULT_SUCCESS then
				pallet:emptyAllFillUnits(true)
			end
			--Die noch leere Palette befüllen
			local fillUnitIndex = pallet:getFirstValidFillUnitToFill(fillTypeIndex)
			delta = pallet:addFillUnitFillLevel(self:getOwnerFarmId(), fillUnitIndex, self.palletSpawner.pendingLiters[fillTypeIndex], fillTypeIndex, ToolType.UNDEFINED)
		else
			--Da Ballen mit vorgegebenen Volumen spawnen, Capacity auslesen um sie aus dem Storage zu entfernen
			delta = pallet.capacity
		end
		self.palletSpawner.pendingLiters[fillTypeIndex] = math.max(self.palletSpawner.pendingLiters[fillTypeIndex] - delta, 0)

		--Bei TREESAPLINGS die Palette abhängig vom Typ ändern
		local currentFillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
		if self.palletSpawner.pendingItem[fillTypeIndex].type == 4 or self.palletSpawner.pendingItem[fillTypeIndex].type == 5 then
			pallet.boughtConfigurations.treeSaplingType[1] = false
			local treeId = self.palletSpawner.pendingItem[fillTypeIndex].treeId
			if treeId >= 20 then
				treeId = treeId - 2
			end
			pallet.boughtConfigurations.treeSaplingType[treeId] = true
			pallet.configurations.treeSaplingType = treeId

			local treetype = g_treePlantManager:getTreeTypeNameFromIndex(self.palletSpawner.pendingItem[fillTypeIndex].treeId)
			local _, variation = pallet:getTreeSaplingPalletType()

			pallet:setTreeSaplingPalletType(treetype, variation)
			local treeType = g_treePlantManager:getTreeTypeDescFromName(treetype).stages[1]
			local treeVisual = treeType[1].palletFilename

			if variation == "DEFAULT" then
				treeVisual = treeType[2].filename
			end

			pallet.spec_treeSaplingPallet.treeTypeFilename = treeVisual
			pallet:updateTreeSaplingVisuals()
		end

		--Filllevel aus Storage abziehen
		local available = self.storage.fillLevels[fillTypeIndex]
		if available ~= null and available > 0 then
			local moved = math.min(delta, available)
			self.storage:setFillLevel(available - moved, fillTypeIndex)
		end
		if self.palletSpawner.pendingLiters[fillTypeIndex] == 0 then
			self.palletSpawner.pendingLiters[fillTypeIndex] = nil
			self.palletSpawner.pendingItem[fillTypeIndex] = nil
		end
	end
end


--Baumarten-Liste erstellen für Auslager-Optionen
function productionStorageControl:getTreeTypes()
	if self.treeTypes == nil then
		self.treeTypes = {}

		for _, treeType in ipairs(g_treePlantManager.treeTypes) do
			if treeType.stages[2] ~= nil then
				local currentType = {}
				currentType.name = treeType.title
				currentType.treeId = treeType.index
				table.insert(self.treeTypes, currentType)
			end
		end
	end

	return self.treeTypes
end


--BallenListe erstellen für Auslager-Optionen
function productionStorageControl:getBaleTypes()
	--Sortierfunktion für die Ballen
	local function compBaleSizes(bale1, bale2)
		if bale1.isRoundbale == bale2.isRoundbale then
			if bale1.isRoundbale then
				return bale1.diameter < bale2.diameter
			else
				return bale1.length < bale2.length
			end
		end
		return bale1.isRoundbale
	end

	--Liste nur erstellen, wenn nicht vorhanden
	if self.baleTypes == nil then
		local baleTypes = {}

		-- Ballenliste erstellen in abhängig vom Filltype, mögliche Ballengrößen werden in Size hinterlegt
		for index, baleType in ipairs(g_baleManager.bales) do
			--Sollte ein Ballen den Flag isAvaible auf false haben ist er für eine Karte deaktiviert, wie z.B. packedsquareBale120/Multibale
			if baleType.isAvailable then
				for index, baleFillType in ipairs(baleType.fillTypes) do
					local fillTypeIndex = baleFillType.fillTypeIndex
					local fillTypeName = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex).name

					--Überprüfen ob der FillType schon existiert
					if baleTypes[fillTypeIndex] == nil then
						baleTypes[fillTypeIndex] = {}
						baleTypes[fillTypeIndex].sizes = {}
					end

					--Mögliche Ballenformate eintragen
					local customEnvironment = baleType.customEnvironment
					if customEnvironment == nil then
						customEnvironment = "VANILLA"
					end
					baleTypes[fillTypeIndex].sizes[#baleTypes[fillTypeIndex].sizes + 1] = {
						isRoundbale = baleType.isRoundbale,
						diameter = baleType.diameter,
						width = baleType.width,
						height = baleType.height,
						length = baleType.length,
						capacity = baleFillType.capacity,
						customEnvironment = customEnvironment
					}
				end
			end
		end

		-- nach Größe sortieren
		for _, baleType in pairs(baleTypes) do
			table.sort(baleType.sizes, compBaleSizes)
		end

		self.baleTypes = baleTypes
	end

	return self.baleTypes
end



function productionStorageControl:update(superFunc)
	if #self.spawnQueue > 0 then
		if self.currentObjectToSpawn == nil then
			self.currentObjectToSpawn = self.spawnQueue[1]
			local spawnPlaces = self.fillTypeToSpawnPlaces[self.currentObjectToSpawn.fillType] or self.spawnPlaces
			if self.currentObjectToSpawn.pallet.type == 1 or self.currentObjectToSpawn.pallet.type == 4 or self.currentObjectToSpawn.pallet.type == 5 or self.currentObjectToSpawn.pallet.type == 6 or self.currentObjectToSpawn.pallet.type == nil then
				g_currentMission.placementManager:getPlaceAsync(spawnPlaces, self.currentObjectToSpawn.pallet.size, self.onSpawnSearchFinished, self)
			else
				g_currentMission.placementManager:getPlaceAsync(spawnPlaces, self.currentObjectToSpawn.pallet.size, self.onSpawnSearchFinishedOther, self)
			end
			return
		end
	else
		g_currentMission:removeUpdateable(self)
	end
end

PalletSpawner.update = Utils.overwrittenFunction(PalletSpawner.update, productionStorageControl.update)



function PalletSpawner:onSpawnSearchFinishedOther(location)
	local objectToSpawn = self.currentObjectToSpawn

	if location ~= nil then
		location.y = location.y + 0.25
		--Ballen Object anlegen
		local baleObject = Bale.new(g_currentMission:getIsServer(), g_currentMission:getIsClient())
		local fillTypeName = g_fillTypeManager:getFillTypeByIndex(objectToSpawn.fillType).name

		if objectToSpawn.pallet.type == 3 then
			--Alle Rundballen auf die Seite drehen, damit diese nicht wegrollen
			location.xRot = location.xRot + (3.1415927 / 2)
		end
		if fillTypeName == "COTTON" then
			--Cotton Quaderballen drehen, damit diese in den Spawnbereich passen und 1,3m hoch verschieben
			location.yRot = location.yRot + (3.1415927 / 2)
			location.y = location.y + 1.30
		end
		if baleObject:loadFromConfigXML(objectToSpawn.pallet.filename, location.x, location.y, location.z, location.xRot, location.yRot, location.zRot) then
			baleObject:setFillType(objectToSpawn.fillType, true)
			baleObject:setOwnerFarmId(objectToSpawn.farmId, true)
			if self.pendingLiters[objectToSpawn.fillType] > objectToSpawn.pallet.capacity then
				baleObject:setFillLevel(objectToSpawn.pallet.capacity, true)
			else
				baleObject:setFillLevel(self.pendingLiters[objectToSpawn.fillType], true)
			end
			if objectToSpawn.pallet.type == 2 and fillTypeName ~= "COTTON" then
				--Grundsätzlich alle Quaderballen mit Kordel, Cotton hat keine Kordel
				baleObject:setVariationId("TWINE")
			elseif objectToSpawn.pallet.type == 3 and fillTypeName ~= "WOODCHIPS" then
				--Grundsätzlich alle Rundballen mit Netwrap
				baleObject:setVariationId("NETWRAP")
				--Cotton Rundballen mit FOILWRAP
				if fillTypeName == "COTTON" then
					baleObject:setVariationId("FOILWRAP")
				end
			end
			if productionStorageControl.wrapped[fillTypeName] == true then
				--Manche Ballen spawnen nur in Folie
				baleObject:setWrappingState(1)
				baleObject:setColor(objectToSpawn.pallet.color1, objectToSpawn.pallet.color2, objectToSpawn.pallet.color3)
			end
			baleObject:register()

			--Manueller Callback
			objectToSpawn.callback(objectToSpawn.callbackTarget, objectToSpawn.pallet, PalletSpawner.RESULT_SUCCESS, objectToSpawn.fillType)
			self.currentObjectToSpawn = nil
			table.remove(self.spawnQueue, 1)
		else
			print("PalletSpawner: Could not spawn bale object")
		end
	else
		objectToSpawn.callback(objectToSpawn.callbackTarget, nil, PalletSpawner.RESULT_NO_SPACE)

		self.currentObjectToSpawn = nil

		table.remove(self.spawnQueue, 1)
	end
end


--Ballen und Baumsetzlinge als Paletten eintragen um Fehler "not supported by loading station or pallet spawner" zu Unterdrücken
function productionStorageControl:getSupportedFillTypes(superFunc)
	self.baleTypes = productionStorageControl:getBaleTypes()
	for fillTypeIndex, _ in pairs(self.baleTypes) do
		if self.fillTypeIdToPallet[fillTypeIndex] == nil then
			--fake Palette anlegen
			local pallet = {}
			pallet.filename = "nope"

			self.fillTypeIdToPallet[fillTypeIndex] = pallet
		end
	end
	
	local treeSaplings = g_fillTypeManager:getFillTypeIndexByName("TREESAPLINGS")
	if self.fillTypeIdToPallet[treeSaplings] == nil then
		local pallet = {}
		pallet.filename = "nope"
		self.fillTypeIdToPallet[treeSaplings] = pallet
	end

	return self.fillTypeIdToPallet
end

PalletSpawner.getSupportedFillTypes = Utils.overwrittenFunction(PalletSpawner.getSupportedFillTypes, productionStorageControl.getSupportedFillTypes)