--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

ProductionSettingsDialog = {}
local ProductionSettingsDialog_mt = Class(ProductionSettingsDialog, YesNoDialog)


function ProductionSettingsDialog.register()
	local productionSettingsDialog = ProductionSettingsDialog.new()
	local path = Utils.getFilename("gui/productionStorageControl_settingsDialog.xml", g_currentModDirectory)
	g_gui:loadGui(path, "ProductionSettingsDialog", productionSettingsDialog)
	ProductionSettingsDialog.INSTANCE = productionSettingsDialog
end


function ProductionSettingsDialog.show(callback, target, title, productionPoint)
	if ProductionSettingsDialog.INSTANCE ~= nil then
		local dialog = ProductionSettingsDialog.INSTANCE
		dialog.productionPoint = productionPoint
		dialog:setCallback(callback, target)
		dialog:setTitle(title)
		dialog:setText(g_i18n:getText("ProductionStorageControl_ChooseSpawnOptionsDialogText"))
		dialog:updateProductionLists()

		g_gui:showDialog("ProductionSettingsDialog")
	end
end


function ProductionSettingsDialog.new(target, custom_mt)
	local self = YesNoDialog.new(target, custom_mt or ProductionSettingsDialog_mt)
	return self
end


--Auswahl verarbeiten
function ProductionSettingsDialog:onClickOk()
	local index = self.productsListMenue:getSelectedIndexInSection()
	local fillType = self.productsList[index]
	if fillType ~= nil then
		local fillTypeIndex = self.productsList[index].fillTypeIndex
		if self.productionPoint.outputFillTypeIds[fillTypeIndex] ~= nil then
			local outputMode = self.productionPoint:getOutputDistributionMode(fillTypeIndex)
			if table.hasElement(ProductionPoint.OUTPUT_MODE, outputMode + 1) then
				self.productionPoint:setOutputDistributionMode(fillTypeIndex, outputMode + 1)
				self:updateProductionLists()
				return
			end
			self.productionPoint:setOutputDistributionMode(fillTypeIndex, 0)
			self:updateProductionLists()
		end
	end
end


--Abbrechen
function ProductionSettingsDialog:onClickBack()
	self:close()
end


--Dialog-Titel einstellen
function ProductionSettingsDialog:setTitle(title)
	ProductionSettingsDialog:superClass().setTitle(self, title)
	self.dialogTitle = title
end


function ProductionSettingsDialog:populateCellForItemInSection(list, section, index, cell)
	if list == self.productsListMenue then
		local entry = self.productsList[index]
		local text = cell:getAttribute("name")
		text:setText(entry.title)
		local icon = cell:getAttribute("icon")
		icon:setImageFilename(entry.icon)

		local outputMode = self.productionPoint:getOutputDistributionMode(entry.fillTypeIndex)
		local outputModeText = g_i18n:getText("ProductionStorageControl_SpawnOption")
		if outputMode == ProductionPoint.OUTPUT_MODE.DIRECT_SELL then
			outputModeText = g_i18n:getText("ui_production_output_selling")
		elseif outputMode == ProductionPoint.OUTPUT_MODE.AUTO_DELIVER then
			outputModeText = g_i18n:getText("ui_production_output_distributing")
		elseif outputMode == ProductionPoint.OUTPUT_MODE.STORE then
			outputModeText = g_i18n:getText("ProductionStorageControl_StoreOption")
		end
		cell:getAttribute("activity"):setText(outputModeText)

	end
--Daten darstellen
end


function ProductionSettingsDialog:updateProductionLists()
	self.productsList = {}

	for _, fillTypeIndex in ipairs(self.productionPoint.outputFillTypeIdsArray) do
		local fillLevel = self.productionPoint:getFillLevel(fillTypeIndex)
		local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
			local entry = {}
			entry.title = fillType.title
			entry.icon = fillType.hudOverlayFilename
			entry.fillLevel = fillLevel
			entry.fillTypeIndex = fillTypeIndex
			table.insert(self.productsList, entry)
	end

	self.productsListMenue:setDataSource(self)
	self.productsListMenue:reloadData()
end


function ProductionSettingsDialog:getNumberOfItemsInSection(list, section)
	if list == self.productsListMenue then
		return #self.productsList or 1
	end

	return 1
end