--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

productionStorageControl = {}


--Grafiken laden fürs Gui
g_overlayManager:addTextureConfigFile(g_currentModDirectory.."gui/productionStorageControl_gui.xml", "productionStorageControl")


--STORE ist State 3
ProductionPoint.OUTPUT_MODE.STORE = 3

--Savegame-Eintrag anmelden
function productionStorageControl.registerSavegameXMLPaths(schema, basePath)
	schema:register(XMLValueType.STRING, basePath .. ".storageFillType(?)", "fillType currently configured to be stored")
end

ProductionPoint.registerSavegameXMLPaths = Utils.prependedFunction(ProductionPoint.registerSavegameXMLPaths, productionStorageControl.registerSavegameXMLPaths)



--STORE im Savegame speichern
function productionStorageControl:saveToXMLFile(xmlFile, key, usedModNames)
	xmlFile:setTable(key .. ".storageFillType", self.outputFillTypeIdsStorage, function (fillTypeKey, _, fillTypeId)
	local fillType = g_fillTypeManager:getFillTypeNameByIndex(fillTypeId)

	xmlFile:setValue(fillTypeKey, fillType)
	end)
end

ProductionPoint.saveToXMLFile = Utils.prependedFunction(ProductionPoint.saveToXMLFile, productionStorageControl.saveToXMLFile)



--STORE synchronisieren
function productionStorageControl:writeStream(streamId, connection)
	ProductionPoint:superClass().writeStream(self, streamId, connection)

	if not connection:getIsServer() then
		streamWriteUInt8(streamId, table.size(self.outputFillTypeIdsStorage))
		for autoStorageFillTypeId in pairs(self.outputFillTypeIdsStorage) do
			streamWriteUIntN(streamId, autoStorageFillTypeId, FillTypeManager.SEND_NUM_BITS)
		end
	end
end

ProductionPoint.writeStream = Utils.prependedFunction(ProductionPoint.writeStream, productionStorageControl.writeStream)


function productionStorageControl:readStream(streamId, connection)
	ProductionPoint:superClass().readStream(self, streamId, connection)
	if connection:getIsServer() then
		--Alle FillTypes auf Auslagern zurück für MP
		for fillType in pairs(self.outputFillTypeIds) do
			if self.outputFillTypeIdsAutoDeliver[fillType] == nil then
				self:setOutputDistributionMode(fillType, ProductionPoint.OUTPUT_MODE.KEEP, true)
			end
		end
		
		for i = 1, streamReadUInt8(streamId) do
			self:setOutputDistributionMode(streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS), ProductionPoint.OUTPUT_MODE.STORE, true)
		end
	end
end

ProductionPoint.readStream = Utils.prependedFunction(ProductionPoint.readStream, productionStorageControl.readStream)


-- STORE aus savegame laden
function productionStorageControl:loadFromXMLFile(superFunc, xmlFile, key)
	--Alle Filltype auf Auslagern stellen, damit diese anschließend aus dem Savegame richtig geladen werden
	for fillType in pairs(self.outputFillTypeIds) do
		if not self.mission.missionInfo.isNewSPCareer then
			self:setOutputDistributionMode(fillType, ProductionPoint.OUTPUT_MODE.KEEP)
		end
	end

	--Normalen Durchlauf
	local success = superFunc(self, xmlFile, key)

	--Umtellen was STORE ist
	xmlFile:iterate(key .. ".storageFillType", function(index, storageKey)
		local fillType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(storageKey))
		if fillType then
			self:setOutputDistributionMode(fillType, ProductionPoint.OUTPUT_MODE.STORE)
		end
	end)
	
	return success
end

ProductionPoint.loadFromXMLFile = Utils.overwrittenFunction(ProductionPoint.loadFromXMLFile, productionStorageControl.loadFromXMLFile)



-- STORE auslesen können
function productionStorageControl:getOutputDistributionMode(superFunc, outputFillTypeId)
	if self.outputFillTypeIdsStorage ~= nil and self.outputFillTypeIdsStorage[outputFillTypeId] ~= nil then
		return ProductionPoint.OUTPUT_MODE.STORE
	end

	return superFunc(self, outputFillTypeId)
end

ProductionPoint.getOutputDistributionMode = Utils.overwrittenFunction(ProductionPoint.getOutputDistributionMode, productionStorageControl.getOutputDistributionMode)



--STORE setzen und Synchro-Event starten wenn nötig
function productionStorageControl:setOutputDistributionMode(superFunc, outputFillTypeId, mode, noEventSend)
	if self.outputFillTypeIds[outputFillTypeId] == nil then
		printf("Error: setOutputDistribution(): fillType \'%s\' is not an output fillType", g_fillTypeManager:getFillTypeNameByIndex(outputFillTypeId))
	else
		local mode = tonumber(mode)
		--CoolDown für den Palettenspawner, damit nicht versehentlich Paletten gespawnt werden beim Umschalten
		self.palletSpawnCooldown = g_time + 4000

		--Alle Modes NIL setzen
		self.outputFillTypeIdsStorage[outputFillTypeId] = nil
		self.outputFillTypeIdsDirectSell[outputFillTypeId] = nil
		self.outputFillTypeIdsAutoDeliver[outputFillTypeId] = nil

		if mode == ProductionPoint.OUTPUT_MODE.STORE then
			self.outputFillTypeIdsStorage[outputFillTypeId] = true
			ProductionPointOutputModeEvent.sendEvent(self, outputFillTypeId, mode, noEventSend)
		else
			superFunc(self, outputFillTypeId, mode, noEventSend)
		end
	end
end

ProductionPoint.setOutputDistributionMode = Utils.overwrittenFunction(ProductionPoint.setOutputDistributionMode, productionStorageControl.setOutputDistributionMode)



function productionStorageControl:load(superFunc, components, xmlFile, key, customEnv, i3dMappings)
	local success = superFunc(self, components, xmlFile, key, customEnv, i3dMappings)
	self.outputFillTypeIdsStorage = {}
	if self.palletSpawner ~= nil then
		self.palletSpawner.pendingLiters = {}
		self.palletSpawner.pendingItem = {}
	end

	--Alles Standardmäßig auf STORE, wird vom Savegame geändert wenn vorhanden
	for outputFillTypeIndex in pairs(self.outputFillTypeIds) do
		self.outputFillTypeIdsStorage[outputFillTypeIndex] = true
	end

	return success
end

ProductionPoint.load = Utils.overwrittenFunction(ProductionPoint.load, productionStorageControl.load)



--STORE-Text im Menü anzeigen
function productionStorageControl:populateCellForItemInSection(list, section, index, cell)
	if list == self.productsList then
		local _, productionPoint = self:getSelectedProduction()
		local production = productionPoint.sortedProductions[index]
		local fillTypeDesc = g_fillTypeManager:getFillTypeByIndex(production.primaryProductFillType)
		cell:getAttribute("name"):setText(production.name or fillTypeDesc.title)
		local fillType = production.primaryProductFillType
		local outputModeText = ""
		if productionPoint.getOutputDistributionMode ~= nil then
			local outputMode = productionPoint:getOutputDistributionMode(fillType)
			outputModeText = g_i18n:getText("ProductionStorageControl_SpawnOption")
			if outputMode == ProductionPoint.OUTPUT_MODE.DIRECT_SELL then
				outputModeText = g_i18n:getText("ui_production_output_selling")
			elseif outputMode == ProductionPoint.OUTPUT_MODE.AUTO_DELIVER then
				outputModeText = g_i18n:getText("ui_production_output_distributing")
			elseif outputMode == ProductionPoint.OUTPUT_MODE.STORE then
				outputModeText = g_i18n:getText("ProductionStorageControl_StoreOption")
			end
		end
		cell:getAttribute("activity"):setText(outputModeText)
	end
end

InGameMenuProductionFrame.populateCellForItemInSection = Utils.appendedFunction(InGameMenuProductionFrame.populateCellForItemInSection, productionStorageControl.populateCellForItemInSection)



function productionStorageControl:updateProduction(superFunc)
	--Pallet Spawn unterbinden
	self.backupPallet = self.waitingForPalletToSpawn
	self.waitingForPalletToSpawn = true

	superFunc(self)

	--Pallet Spawn ausführen
	self.waitingForPalletToSpawn = self.backupPallet

	if self.isServer and (self.isOwned and (g_time > self.palletSpawnCooldown and not self.waitingForPalletToSpawn)) then
		local nextFillTypeId = nil
		while true do
			local fillTypeId = self.lastPalletFillTypeId
			if fillTypeId ~= nil and (self.outputFillTypeIdsDirectSell[fillTypeId] == nil and self.outputFillTypeIdsAutoDeliver[fillTypeId] == nil and self.outputFillTypeIdsStorage[fillTypeId] == nil ) then
				local fillLevel = self.storage:getFillLevel(fillTypeId)
				if fillLevel > 0 then
					local pallet = self.outputFillTypeIdsToPallets[fillTypeId]
					if pallet and pallet.filename ~= "nope" and pallet.capacity <= fillLevel then
						nextFillTypeId = fillTypeId
						break
					end
				end
			end
			self.lastPalletFillTypeId = next(self.outputFillTypeIdsToPallets, self.lastPalletFillTypeId)
			if self.lastPalletFillTypeId == nil then
				break
			end
		end
		if nextFillTypeId ~= nil then
			self.waitingForPalletToSpawn = true
			self.palletSpawner:spawnPallet(self:getOwnerFarmId(), nextFillTypeId, self.palletSpawnRequestCallback, self)
		end
	end

end

ProductionPoint.updateProduction = Utils.overwrittenFunction(ProductionPoint.updateProduction, productionStorageControl.updateProduction)



--Alle Verfügbaren Paletten erfassen damit alle gespawnt werden können. Es werden nur die wichtigsten Daten ausgelesen aus Performance-Gründen
function productionStorageControl.loadFromXMLFile(self, superFunc, xmFile, xmlKey, xmlBaseDirectory, xmlCustomEnvironment)
	local palletPath = xmFile:getValue(xmlKey .. ".pallet#filename", nil, xmlBaseDirectory)
	if palletPath ~= nil then
		if self.pallets == nil then
			self.pallets = {}
		end
		if xmlCustomEnvironment == nil then
			self.pallets["VANILLA"] = palletPath
		else
			self.pallets[xmlCustomEnvironment] = palletPath
		end
	end
	local result = superFunc(self, xmFile, xmlKey, xmlBaseDirectory, xmlCustomEnvironment)
	return result
end

FillTypeDesc.loadFromXMLFile = Utils.overwrittenFunction(FillTypeDesc.loadFromXMLFile, productionStorageControl.loadFromXMLFile)