EAS_InseminateClusterEvent = {}

local EAS_InseminateClusterEvent_mt = Class(EAS_InseminateClusterEvent, Event)
InitEventClass(EAS_InseminateClusterEvent, "EAS_InseminateClusterEvent")

function EAS_InseminateClusterEvent.emptyNew()
    local self = Event.new(EAS_InseminateClusterEvent_mt)

    return self
end

function EAS_InseminateClusterEvent.new(husbandry, clusterId, numberOfAnimals)
    local self = EAS_InseminateClusterEvent.emptyNew()

    self.husbandry = husbandry
    self.clusterId = clusterId
    self.numberOfAnimals = numberOfAnimals

    return self
end

function EAS_InseminateClusterEvent:readStream(streamId, connection)
    self.husbandry = NetworkUtil.readNodeObject(streamId)
    self.clusterId = streamReadInt32(streamId)
    self.numberOfAnimals = streamReadInt32(streamId)

    self:run(connection)
end

function EAS_InseminateClusterEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.husbandry)
    streamWriteInt32(streamId, self.clusterId)
    streamWriteInt32(streamId, self.numberOfAnimals)
end

function EAS_InseminateClusterEvent:run(connection)
    local clusterSystem = self.husbandry.spec_husbandryAnimals.clusterSystem
    local cluster = clusterSystem:getClusterById(self.clusterId)
    EAS_AnimalCluster.inseminate(cluster, self.numberOfAnimals)
end